/*
 * JS for Camera generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

Camera_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'q_slider': 'Camera_q_slider',
        'spacer_18': 'Camera_spacer_18',
        'mobilebutton_1': 'Camera_mobilebutton_1',
        'mobilegrid_12': 'Camera_mobilegrid_12',
        'mobilegridcell_13': 'Camera_mobilegridcell_13',
        'mobilegridcell_14': 'Camera_mobilegridcell_14',
        'cameraimage': 'Camera_cameraimage',
        'mobilegridcell_17': 'Camera_mobilegridcell_17',
        'photo_lenght': 'Camera_photo_lenght',
        'photo_percent': 'Camera_photo_percent',
        'save_android': 'Camera_save_android',
        'save_ios': 'Camera_save_ios',
        'spacer_11': 'Camera_spacer_11',
        'settings_clps': 'Camera_settings_clps',
        'mobilecollapsblockheader_20': 'Camera_mobilecollapsblockheader_20',
        'mobilecollapsblockcontent_21': 'Camera_mobilecollapsblockcontent_21',
        'mobilelabel_29': 'Camera_mobilelabel_29',
        'pict_width': 'Camera_pict_width',
        'mobilelabel_30': 'Camera_mobilelabel_30',
        'pict_height': 'Camera_pict_height',
        'mobilelabel_31': 'Camera_mobilelabel_31',
        'pict_qty': 'Camera_pict_qty',
        'mobilelabel_32': 'Camera_mobilelabel_32',
        'lbl234': 'Camera_lbl234',
        'slice_length': 'Camera_slice_length',
        'picture_name': 'Camera_picture_name'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'Camera';

    /*
     * Nonvisual components
     */
    var datasources = [];

    mobilecamera = new Appery.DataSource(CameraService, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("Camera");
        },
        'onSuccess': function(data) {
            var joker = localStorage.getItem('CurrentCameraPicture');
            var n = joker.length;
            $('[dsid="photo_lenght"]').text(n);
        },
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['imageDataBase64'],
            'ID': 'cameraimage',
            'ATTR': 'src'
        }, {
            'PATH': ['imageDataBase64'],
            'ID': '___local_storage___',
            'ATTR': 'CurrentCameraPicture'
        }],
        'requestMapping': [{
            'PATH': ['quality'],
            'TYPE': 'STRING',
            'ID': 'q_slider',
            'ATTR': 'value'
        }, {
            'PATH': ['destinationType'],
            'TYPE': 'STRING',
            'ATTR': 'Data URL'
        }, {
            'PATH': ['sourcetype'],
            'TYPE': 'STRING',
            'ATTR': 'Camera'
        }, {
            'PATH': ['allowedit'],
            'TYPE': 'STRING',
            'ATTR': 'true'
        }, {
            'PATH': ['encodingType'],
            'TYPE': 'STRING',
            'ATTR': 'JPEG'
        }, {
            'PATH': ['targetWidth'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'pict_width'
        }, {
            'PATH': ['targetHeight'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'pict_height'
        }]
    });

    datasources.push(mobilecamera);

    picturesave = new Appery.DataSource(SavePicture, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("Camera");
        },
        'onSuccess': function(data) {
            alert('Picture saved OK');
        },
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'savedpicture[0]', 'picturelocation'],
            'ID': 'picture_name',
            'ATTR': 'value'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['picturebase64'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'CurrentCameraPicture'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }, {
            'PATH': ['relatedid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'relatedid'
        }]
    });

    datasources.push(picturesave);

    sj = new Appery.DataSource(savejpg, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("Camera");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['photstring'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'CurrentCameraPicture'
        }, {
            'PATH': ['recid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url_port'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(sj);

    sslice = new Appery.DataSource(sendslice, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("Camera");
        },
        'onSuccess': function(data) { //alert('success');
            var joker = localStorage.getItem('CurrentCameraPicture');
            var n = joker.length;
            var slice_no = localStorage.getItem('sslice_no');
            var slice_lenght = localStorage.getItem('slice_length');
            var slice_rsp = localStorage.getItem('sslice_rsp');
            var slice_id = localStorage.getItem('sslice_id');
            //var percent = 10;
            //alert(slice_id+'/'+slice_lenght+'/'+slice_no);
            var percent = (100 * Number(slice_lenght) * Number(slice_no)) / n;
            if (percent > 100) {
                $('[dsid="photo_percent"]').text('100% - file saved!');
            } else {
                $('[dsid="photo_percent"]').text(percent.toPrecision(2) + '%');
            }

            //alert('final');
            if (slice_rsp == 'OK') {
                var joker = localStorage.getItem('CurrentCameraPicture');
                var sl = Number(slice_lenght);
                var sn = Number(slice_no);
                localStorage.setItem('sslice_no', sn + 1);
                var n2slice = joker.slice(sl * sn, sl * (sn + 1));
                localStorage.setItem('current_slice', n2slice);

                if (n2slice.length == 0) {
                    localStorage.setItem('sslice_loc', 'OUT');
                }

                //alert('ok')
                sslice.execute({});
            };
        },
        'onError': function(jqXHR, textStatus, errorThrown) {
            var joker = localStorage.getItem('CurrentCameraPicture');
            var slice_no = localStorage.getItem('sslice_no');
            var slice_lenght = localStorage.getItem('slice_length');
            var n = joker.length;

            var percent = (100 * Number(slice_lenght) * Number(slice_no)) / n;

            $('[dsid="photo_percent"]').text(percent.toPrecision(2) + '% error/slice send again started!');

            //alert('error/slice send again started!');
            sslice.execute({});
        },
        'responseMapping': [{
            'PATH': ['data', 'slicersp[0]', 'rsp'],
            'ID': '___local_storage___',
            'ATTR': 'sslice_rsp'
        }, {
            'PATH': ['data', 'slicersp[0]', 'rsp_no'],
            'ID': '___local_storage___',
            'ATTR': 'sslice_no'
        }, {
            'PATH': ['data', 'slicersp[0]', 'picture_id'],
            'ID': '___local_storage___',
            'ATTR': 'sslice_id'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['slice_number'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'sslice_no'
        }, {
            'PATH': ['slice_text'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'current_slice'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }, {
            'PATH': ['slice_id'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'sslice_id'
        }, {
            'PATH': ['slice_loc'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'sslice_loc'
        }]
    });

    datasources.push(sslice);

    /*
     * Events and handlers
     */

    // Before Show
    Camera_beforeshow = function() {
        Appery.CurrentScreen = "Camera";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_E706_onLoad = Camera_onLoad = function() {
        screen_E706_elementsExtraJS();
        // Set SAVE button depending on platform
        // IOS can't save picture at once now
        // 
        var devicePlatform = device.platform;
        if (devicePlatform == 'iOS') {
            $('[dsid="save_ios"]').show();

        } else {
            //$('[dsid="save_android"]').show(n);
            // same for both platforms // change when needed // direct save works only for deployed apps not test mode (Appery proxy!)
            $('[dsid="save_ios"]').show();
        }

        // code for camera settings variables
        var joker = localStorage.getItem('pict_width');
        var n = Number(joker);

        if (n == 0) {
            localStorage.setItem('pict_width', 1024);
            localStorage.setItem('pict_height', 720);
            localStorage.setItem('pict_qty', 40);
            $('[dsid="pict_width"]').val(1024);
            $('[dsid="pict_height"]').val(720);
            $('[dsid="pict_qty"]').val(40);
        }

        localStorage.setItem('slice_length', 5000)

        // code to change phot SAVE speed    
        //var joker1 = localStorage.getItem('slice_length');
        //var n1 = Number(joker1);
        //if (n1==0)
        //{
        //     localStorage.setItem('slice_length',5000);
        //     $('[dsid="slice_length"]').val(5000);
        //};
        setAttribute_('Camera_pict_width', 'value', localStorage.getItem('pict_width'));
        $('[id="Camera_pict_width"]').refresh();
        setAttribute_('Camera_pict_height', 'value', localStorage.getItem('pict_height'));
        $('[id="Camera_pict_height"]').refresh();
        setAttribute_('Camera_pict_qty', 'value', localStorage.getItem('pict_qty'));
        $('[id="Camera_pict_qty"]').refresh();
        setAttribute_('Camera_q_slider', 'value', localStorage.getItem('pict_qty'));
        $('[id="Camera_q_slider"]').refresh();
        localStorage.setItem('relatedid', 'generic');
        setAttribute_('Camera_slice_length', 'value', localStorage.getItem('slice_legth'));
        $('[id="Camera_slice_length"]').refresh();

        // TODO fire device events only if necessary (with JS logic)
        Camera_deviceEvents();
        Camera_windowEvents();
        screen_E706_elementsEvents();
    }

    // screen window events
    screen_E706_windowEvents = Camera_windowEvents = function() {

        $('#Camera').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    Camera_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_E706_elementsExtraJS = Camera_elementsExtraJS = function() {
        // screen (Camera) extra code

        /* settings_clps */

        $("#Camera_settings_clps .ui-collapsible-heading-toggle").attr("tabindex", "10");

    }

    // screen elements handler
    screen_E706_elementsEvents = Camera_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#Camera_mobilecontainer [name="mobilebutton_1"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    try {
                        mobilecamera.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });

        $('#Camera_mobilecontainer [name="save_android"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    try {
                        picturesave.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });
        $('#Camera_mobilecontainer [name="save_ios"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    var joker = localStorage.getItem('CurrentCameraPicture');
                    //var joker = "xkjnckjvnshbfuidfhsvbiu"
                    var n = joker.length;
                    $('[dsid="photo_lenght"]').text(n);
                    //localStorage.setItem('slice_lenght',5000);
                    var slice_length = localStorage.getItem('slice_lenght');
                    localStorage.setItem('sslice_id', 'first');
                    localStorage.setItem('sslice_no', 1);
                    localStorage.setItem('sslice_loc', 'IN');
                    localStorage.setItem('current_slice', joker.slice(1, slice_length));;
                    try {
                        sslice.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });

        $('#Camera_mobilecontainer [name="pict_width"]').die().live({
            change: function() {
                setVar_('pict_width', 'Camera_pict_width', 'value', '', this);
            },
        });

        $('#Camera_mobilecontainer [name="pict_height"]').die().live({
            change: function() {
                setVar_('pict_height', 'Camera_pict_height', 'value', '', this);
            },
        });

        $('#Camera_mobilecontainer [name="pict_qty"]').die().live({
            change: function() {
                setVar_('pict_qty', 'Camera_pict_qty', 'value', '', this);
                setAttribute_('Camera_q_slider', 'value', localStorage.getItem('pict_qty'));
                $('[id="Camera_q_slider"]').refresh();
            },
        });

        $('#Camera_mobilecontainer [name="slice_length"]').die().live({
            change: function() {
                setVar_('slice_length', 'Camera_slice_length', 'value', '', this);
            },
        });

    }

    $("#Camera").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        Camera_beforeshow();
    });

    if (runBeforeShow) {
        Camera_beforeshow();
    } else {
        Camera_onLoad();
    }

}

$("#Camera").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    Camera_js();
});