/*
 * JS for Customers generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

Customers_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'mobilelist_1': 'Customers_mobilelist_1',
        'mobilelistitem_2': 'Customers_mobilelistitem_2',
        'mobilelistitembutton_3': 'Customers_mobilelistitembutton_3',
        'customer': 'Customers_customer',
        'cid': 'Customers_cid'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'Customers';

    /*
     * Nonvisual components
     */
    var datasources = [];

    customers_lst = new Appery.DataSource(customers_list, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("Customers");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'customers'],
            'ID': 'mobilelistitem_2',
            'SET': [{
                'PATH': ['companyname'],
                'ID': 'customer',
                'ATTR': '@'
            }, {
                'PATH': ['customerid'],
                'ID': 'cid',
                'ATTR': '@'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(customers_lst);

    /*
     * Events and handlers
     */

    // Before Show
    Customers_beforeshow = function() {
        Appery.CurrentScreen = "Customers";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_74D2_onLoad = Customers_onLoad = function() {
        screen_74D2_elementsExtraJS();

        // TODO fire device events only if necessary (with JS logic)
        Customers_deviceEvents();
        Customers_windowEvents();
        screen_74D2_elementsEvents();
    }

    // screen window events
    screen_74D2_windowEvents = Customers_windowEvents = function() {

        $('#Customers').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });
        $('#Customers').bind({
            pageshow: function() {
                try {
                    customers_lst.execute({})
                } catch (ex) {
                    console.log(ex.name + '  ' + ex.message);
                    hideSpinner();
                };
            },
        });

    }

    // device events
    Customers_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_74D2_elementsExtraJS = Customers_elementsExtraJS = function() {
        // screen (Customers) extra code

        /* mobilelist_1 */

        listView = $("#Customers_mobilelist_1");
        theme = listView.attr("data-theme");
        if (typeof theme !== 'undefined') {
            var themeClass = "ui-btn-up-" + theme;
            listItem = $("#Customers_mobilelist_1 .ui-li-static");
            $.each(listItem, function(index, value) {
                $(this).addClass(themeClass);
            });
        }

        /* mobilelistitem_2 */

    }

    // screen elements handler
    screen_74D2_elementsEvents = Customers_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#Customers_mobilecontainer [name="mobilelistitem_2"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    setVar_('customerid', 'Customers_cid', 'text', '', this);
                    Appery.navigateTo('customer_edit', {
                        transition: 'pop'
                    });

                }
            },
        });

    }

    $("#Customers").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        Customers_beforeshow();
    });

    if (runBeforeShow) {
        Customers_beforeshow();
    } else {
        Customers_onLoad();
    }

}

$("#Customers").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    Customers_js();
});