/*
 * JS for Products generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

Products_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'mobilelist_2': 'Products_mobilelist_2',
        'product_list': 'Products_product_list',
        'mobilelistitembutton_4': 'Products_mobilelistitembutton_4',
        'productname': 'Products_productname',
        'productid': 'Products_productid'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'Products';

    /*
     * Nonvisual components
     */
    var datasources = [];

    products_list = new Appery.DataSource(products, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("Products");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'products'],
            'ID': 'product_list',
            'SET': [{
                'PATH': ['productid'],
                'ID': 'productid',
                'ATTR': '@'
            }, {
                'PATH': ['productname'],
                'ID': 'productname',
                'ATTR': '@'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(products_list);

    /*
     * Events and handlers
     */

    // Before Show
    Products_beforeshow = function() {
        Appery.CurrentScreen = "Products";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_A738_onLoad = Products_onLoad = function() {
        screen_A738_elementsExtraJS();
        try {
            products_list.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        Products_deviceEvents();
        Products_windowEvents();
        screen_A738_elementsEvents();
    }

    // screen window events
    screen_A738_windowEvents = Products_windowEvents = function() {

        $('#Products').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    Products_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_A738_elementsExtraJS = Products_elementsExtraJS = function() {
        // screen (Products) extra code

        /* mobilelist_2 */

        listView = $("#Products_mobilelist_2");
        theme = listView.attr("data-theme");
        if (typeof theme !== 'undefined') {
            var themeClass = "ui-btn-up-" + theme;
            listItem = $("#Products_mobilelist_2 .ui-li-static");
            $.each(listItem, function(index, value) {
                $(this).addClass(themeClass);
            });
        }

        /* product_list */

    }

    // screen elements handler
    screen_A738_elementsEvents = Products_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#Products_mobilecontainer [name="product_list"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    setVar_('productid', 'Products_productid', 'text', '', this);
                    Appery.navigateTo('product', {
                        transition: 'pop'
                    });

                }
            },
        });

    }

    $("#Products").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        Products_beforeshow();
    });

    if (runBeforeShow) {
        Products_beforeshow();
    } else {
        Products_onLoad();
    }

}

$("#Products").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    Products_js();
});