/*
 * JS for create_order generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

create_order_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'companyname': 'create_order_companyname',
        'mobilelabel_3': 'create_order_mobilelabel_3',
        'customers_list': 'create_order_customers_list',
        'mobileselectmenuitem_2': 'create_order_mobileselectmenuitem_2',
        'date_label': 'create_order_date_label',
        'orderdate': 'create_order_orderdate',
        'mobilelabel_5': 'create_order_mobilelabel_5',
        'address': 'create_order_address',
        'cgrid1': 'create_order_cgrid1',
        'address_detail': 'create_order_address_detail',
        'city': 'create_order_city',
        'mobilegridcell_9': 'create_order_mobilegridcell_9',
        'region': 'create_order_region',
        'mobilegridcell_10': 'create_order_mobilegridcell_10',
        'postalcode': 'create_order_postalcode',
        'mobilegridcell_11': 'create_order_mobilegridcell_11',
        'phone': 'create_order_phone',
        'mobilelabel_16': 'create_order_mobilelabel_16',
        'shippers_list': 'create_order_shippers_list',
        'mobileselectmenuitem_18': 'create_order_mobileselectmenuitem_18',
        'spacer_39': 'create_order_spacer_39',
        'mobilegrid_34': 'create_order_mobilegrid_34',
        'mobilegridcell_35': 'create_order_mobilegridcell_35',
        'savebutton': 'create_order_savebutton',
        'mobilegridcell_36': 'create_order_mobilegridcell_36',
        'cancelbutton': 'create_order_cancelbutton'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'create_order';

    /*
     * Nonvisual components
     */
    var datasources = [];

    list_of_customers = new Appery.DataSource(customers_list, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("create_order");
        },
        'onSuccess': function(data) {
            setAttribute_('create_order_customers_list', 'selectedIndex', 'AHA201');
            $('[id="create_order_customers_list"]').refresh();
        },
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'customers'],
            'ID': 'customers_list-0',
            'SET': [{
                'PATH': ['companyname'],
                'ID': 'customers_list-0',
                'ATTR': '@'
            }, {
                'PATH': ['customerid'],
                'ID': 'customers_list-0',
                'ATTR': 'value'
            }]
        }, {
            'PATH': ['data', 'customers[0]', 'companyname'],
            'ID': 'companyname',
            'ATTR': '@'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(list_of_customers);

    selected_customer = new Appery.DataSource(customer_record, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("create_order");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'customers_rec[0]', 'companyname'],
            'ID': 'companyname',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'address'],
            'ID': 'address',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'city'],
            'ID': 'city',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'region'],
            'ID': 'region',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'postalcode'],
            'ID': 'postalcode',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'phone'],
            'ID': 'phone',
            'ATTR': '@'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['customerid'],
            'TYPE': 'STRING',
            'ID': 'customers_list',
            'ATTR': 'value'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(selected_customer);

    shippers_list = new Appery.DataSource(shippers, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("create_order");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'shippers'],
            'ID': 'shippers_list-0',
            'SET': [{
                'PATH': ['shipperid'],
                'ID': 'shippers_list-0',
                'ATTR': 'value'
            }, {
                'PATH': ['companyname'],
                'ID': 'shippers_list-0',
                'ATTR': '@'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(shippers_list);

    create_new_order = new Appery.DataSource(psg_create_order, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("create_order");
        },
        'onSuccess': function(data) {
            closePopup();
        },
        'onError': function(jqXHR, textStatus, errorThrown) {
            alert('error create order');
        },
        'responseMapping': [],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['orderid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'orderid'
        }, {
            'PATH': ['customerid'],
            'TYPE': 'STRING',
            'ID': 'customers_list',
            'ATTR': 'value'
        }, {
            'PATH': ['employeeid'],
            'TYPE': 'STRING',
            'ATTR': 'E3BZ0Q5VKJAA'
        }, {
            'PATH': ['orderdate'],
            'TYPE': 'STRING',
            'ID': 'orderdate',
            'ATTR': 'defaultDateValue'
        }, {
            'PATH': ['shipname'],
            'TYPE': 'STRING',
            'ID': 'companyname',
            'ATTR': '@'
        }, {
            'PATH': ['shipaddress'],
            'TYPE': 'STRING',
            'ID': 'address',
            'ATTR': 'value'
        }, {
            'PATH': ['shipcity'],
            'TYPE': 'STRING',
            'ID': 'city',
            'ATTR': '@'
        }, {
            'PATH': ['shipregion'],
            'TYPE': 'STRING',
            'ID': 'region',
            'ATTR': '@'
        }, {
            'PATH': ['shipperid'],
            'TYPE': 'STRING',
            'ID': 'shippers_list',
            'ATTR': 'value'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(create_new_order);

    new_order_data = new Appery.DataSource(new_order, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("create_order");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'new_order[0]', 'orderid'],
            'ID': '___local_storage___',
            'ATTR': 'orderid'
        }, {
            'PATH': ['data', 'new_order[0]', 'orderdate'],
            'ID': 'orderdate',
            'ATTR': 'dateFormat'
        }, {
            'PATH': ['data', 'new_order[0]', 'dateformat'],
            'ID': 'orderdate',
            'ATTR': 'defaultDateValue'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(new_order_data);

    /*
     * Events and handlers
     */

    // Before Show
    create_order_beforeshow = function() {
        Appery.CurrentScreen = "create_order";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_E3EB_onLoad = create_order_onLoad = function() {
        screen_E3EB_elementsExtraJS();
        try {
            new_order_data.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };
        try {
            list_of_customers.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        create_order_deviceEvents();
        create_order_windowEvents();
        screen_E3EB_elementsEvents();
    }

    // screen window events
    screen_E3EB_windowEvents = create_order_windowEvents = function() {

        $('#create_order').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    create_order_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_E3EB_elementsExtraJS = create_order_elementsExtraJS = function() {
        // screen (create_order) extra code

        /* customers_list */

        $("#create_order_customers_list").parent().find("a.ui-btn").attr("tabindex", "1");

        /* orderdate */

        create_order_orderdate_selector = "#create_order_orderdate";
        create_order_orderdate_dataPickerOptions = {
            dateFormat: "yy-mm-dd",
            firstDay: 1,

            maxDate: new Date(""),

            minDate: new Date(""),

            dayNamesMin: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
            monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
            showOtherMonths: true
        };

        create_order_orderdate_dataPickerOptions.defaultDate = new Date("08/01/2013");

        Appery.__registerComponent('orderdate', new Appery.ApperyMobileDatePickerComponent("create_order_orderdate", create_order_orderdate_dataPickerOptions));

        /* shippers_list */

        $("#create_order_shippers_list").parent().find("a.ui-btn").attr("tabindex", "4");

    }

    // screen elements handler
    screen_E3EB_elementsEvents = create_order_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#create_order_customers_container [name="customers_list"]').die().live({
            change: function() {
                try {
                    selected_customer.execute({})
                } catch (ex) {
                    console.log(ex.name + '  ' + ex.message);
                    hideSpinner();
                };
                try {
                    shippers_list.execute({})
                } catch (ex) {
                    console.log(ex.name + '  ' + ex.message);
                    hideSpinner();
                };
            },
        });

        $('#create_order_customers_container [name="orderdate"]').die().live({
            change: function() {
                setVar_('orderdate', 'create_order_orderdate', 'defaultDateValue', '', this);
            },
        });

        $('#create_order_customers_container [name="savebutton"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) { //
                    var crud_create = '"orderid":"' + localStorage.getItem('orderid') + '"';
                    crud_create = crud_create + ',"customerid":"' + Appery('customers_list').val() + '"';
                    crud_create = crud_create + ',"employeeid":"E3BZ0Q5VKJAA"';
                    var odt = localStorage.getItem('orderdate');
                    odt = odt[6] + odt[7] + odt[8] + odt[9] + '-' + odt[0] + odt[1] + '-' + odt[3] + odt[4];

                    crud_create = crud_create + ',"orderdate":"' + odt + '"';
                    crud_create = crud_create + ',"shipname":"' + Appery('companyname').text() + '"';
                    crud_create = crud_create + ',"shipaddress":"' + Appery('address').val() + '"';
                    crud_create = crud_create + ',"shipcity":"' + Appery('city').text() + '"';
                    crud_create = crud_create + ',"shipregion":"' + Appery('region').text() + '"';
                    crud_create = '{' + crud_create + '}';
                    localStorage.setItem('psg_create_request', crud_create);
                    //alert(localStorage.getItem('psg_create_request'));
                    try {
                        create_new_order.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });

        $('#create_order_customers_container [name="cancelbutton"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    closePopup();

                }
            },
        });

    }

    $("#create_order").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        create_order_beforeshow();
    });

    if (runBeforeShow) {
        create_order_beforeshow();
    } else {
        create_order_onLoad();
    }

}

$("#create_order").die("dialoginit").live("dialoginit", function(event, ui) {
    Appery.processSelectMenu($(this));
    create_order_js();
});

$("#create_order").die("dialogcreate").live("dialogcreate", function(event, ui) {
    //Most components initializations are done on "pagecreate" event. This event must be triggered for dialogs too.
    $(this).trigger("pagecreate");
});