/*
 * JS for customer_details generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

customer_details_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'company_label': 'customer_details_company_label',
        'CompanyName': 'customer_details_CompanyName',
        'contact_label': 'customer_details_contact_label',
        'contactname': 'customer_details_contactname',
        'address_label': 'customer_details_address_label',
        'address': 'customer_details_address',
        'city_label': 'customer_details_city_label',
        'city': 'customer_details_city',
        'region_label': 'customer_details_region_label',
        'region': 'customer_details_region',
        'phone_label': 'customer_details_phone_label',
        'phone': 'customer_details_phone',
        'spacer_15': 'customer_details_spacer_15',
        'save_button': 'customer_details_save_button'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'customer_details';

    /*
     * Nonvisual components
     */
    var datasources = [];

    customer_fields = new Appery.DataSource(customer_record, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("customer_details");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'customers_rec[0]', 'companyname'],
            'ID': 'CompanyName',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'contactname'],
            'ID': 'contactname',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'address'],
            'ID': 'address',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'city'],
            'ID': 'city',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'region'],
            'ID': 'region',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'phone'],
            'ID': 'phone',
            'ATTR': 'value'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['customerid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'customerid'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(customer_fields);

    customers_update = new Appery.DataSource(psg_update_customer, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("customer_details");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {
            Appery.navigateTo('update_error', {
                transition: 'pop'
            });
        },
        'responseMapping': [],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['psg_at_reccord'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'psg_update_request'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(customers_update);

    /*
     * Events and handlers
     */

    // Before Show
    customer_details_beforeshow = function() {
        Appery.CurrentScreen = "customer_details";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_4A33_onLoad = customer_details_onLoad = function() {
        screen_4A33_elementsExtraJS();

        // TODO fire device events only if necessary (with JS logic)
        customer_details_deviceEvents();
        customer_details_windowEvents();
        screen_4A33_elementsEvents();
    }

    // screen window events
    screen_4A33_windowEvents = customer_details_windowEvents = function() {

        $('#customer_details').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });
        $('#customer_details').bind({
            pageshow: function() {
                try {
                    customer_fields.execute({})
                } catch (ex) {
                    console.log(ex.name + '  ' + ex.message);
                    hideSpinner();
                };
            },
        });

    }

    // device events
    customer_details_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_4A33_elementsExtraJS = customer_details_elementsExtraJS = function() {
        // screen (customer_details) extra code

    }

    // screen elements handler
    screen_4A33_elementsEvents = customer_details_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#customer_details_mobilecontainer [name="CompanyName"]').die().live({
            change: function() {
                toggle('customer_details_save_button', 'mob', 'true');
            },
        });

        $('#customer_details_mobilecontainer [name="contactname"]').die().live({
            change: function() {
                toggle('customer_details_save_button', 'mob', 'true');
            },
        });

        $('#customer_details_mobilecontainer [name="address"]').die().live({
            change: function() {
                toggle('customer_details_save_button', 'mob', 'true');
            },
        });

        $('#customer_details_mobilecontainer [name="city"]').die().live({
            change: function() {
                toggle('customer_details_save_button', 'mob', 'true');
            },
        });

        $('#customer_details_mobilecontainer [name="region"]').die().live({
            change: function() {
                toggle('customer_details_save_button', 'mob', 'true');
            },
        });

        $('#customer_details_mobilecontainer [name="phone"]').die().live({
            change: function() {
                toggle('customer_details_save_button', 'mob', 'true');
            },
        });

        $('#customer_details_mobilecontainer [name="save_button"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    var crud_update = '"customerid":"' + localStorage.getItem('customerid') + '"';
                    crud_update = crud_update + ',"companyname":"' + Appery('CompanyName').val() + '"';
                    crud_update = crud_update + ',"contactname":"' + Appery('contactname').val() + '"';
                    crud_update = crud_update + ',"address":"' + Appery('address').val() + '"';
                    crud_update = crud_update + ',"city":"' + Appery('city').val() + '"';
                    crud_update = crud_update + ',"region":"' + Appery('region').val() + '"';
                    crud_update = crud_update + ',"phone":"' + Appery('phone').val() + '"';
                    crud_update = '{' + crud_update + '}';
                    localStorage.setItem('psg_update_request', crud_update);
                    //var see_text = localStorage.getItem('psg_update_request');
                    //alert(crud_update);
                    //alert(see_text);
                    try {
                        customers_update.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });

    }

    $("#customer_details").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        customer_details_beforeshow();
    });

    if (runBeforeShow) {
        customer_details_beforeshow();
    } else {
        customer_details_onLoad();
    }

}

$("#customer_details").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    customer_details_js();
});