/*
 * JS for customer_edit generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

customer_edit_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'mobilelabel_1': 'customer_edit_mobilelabel_1',
        'companyname': 'customer_edit_companyname',
        'mobilelabel_3': 'customer_edit_mobilelabel_3',
        'contactname': 'customer_edit_contactname',
        'mobilelabel_5': 'customer_edit_mobilelabel_5',
        'address': 'customer_edit_address',
        'mobilelabel_7': 'customer_edit_mobilelabel_7',
        'city': 'customer_edit_city',
        'mobilelabel_9': 'customer_edit_mobilelabel_9',
        'region': 'customer_edit_region',
        'mobilelabel_11': 'customer_edit_mobilelabel_11',
        'phone': 'customer_edit_phone',
        'spacer_13': 'customer_edit_spacer_13',
        'mobilegrid_14': 'customer_edit_mobilegrid_14',
        'mobilegridcell_15': 'customer_edit_mobilegridcell_15',
        'savebutton': 'customer_edit_savebutton',
        'mobilegridcell_16': 'customer_edit_mobilegridcell_16',
        'cancelbutton': 'customer_edit_cancelbutton'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'customer_edit';

    /*
     * Nonvisual components
     */
    var datasources = [];

    customer_flds = new Appery.DataSource(customer_record, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("customer_edit");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'customers_rec[0]', 'companyname'],
            'ID': 'companyname',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'contactname'],
            'ID': 'contactname',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'address'],
            'ID': 'address',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'city'],
            'ID': 'city',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'region'],
            'ID': 'region',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'customers_rec[0]', 'phone'],
            'ID': 'phone',
            'ATTR': 'value'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['customerid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'customerid'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(customer_flds);

    customer_update = new Appery.DataSource(psg_update_customer, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("customer_edit");
        },
        'onSuccess': function(data) {
            closePopup();
        },
        'onError': function(jqXHR, textStatus, errorThrown) {
            Appery.navigateTo('update_error', {
                transition: 'pop'
            });
        },
        'responseMapping': [],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['psg_at_reccord'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'psg_update_request'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(customer_update);

    /*
     * Events and handlers
     */

    // Before Show
    customer_edit_beforeshow = function() {
        Appery.CurrentScreen = "customer_edit";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_1D09_onLoad = customer_edit_onLoad = function() {
        screen_1D09_elementsExtraJS();
        try {
            customer_flds.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        customer_edit_deviceEvents();
        customer_edit_windowEvents();
        screen_1D09_elementsEvents();
    }

    // screen window events
    screen_1D09_windowEvents = customer_edit_windowEvents = function() {

        $('#customer_edit').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    customer_edit_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_1D09_elementsExtraJS = customer_edit_elementsExtraJS = function() {
        // screen (customer_edit) extra code

    }

    // screen elements handler
    screen_1D09_elementsEvents = customer_edit_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#customer_edit_mobilecontainer [name="savebutton"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    var crud_update = '"customerid":"' + localStorage.getItem('customerid') + '"';
                    crud_update = crud_update + ',"companyname":"' + Appery('companyname').val() + '"';
                    crud_update = crud_update + ',"contactname":"' + Appery('contactname').val() + '"';
                    crud_update = crud_update + ',"address":"' + Appery('address').val() + '"';
                    crud_update = crud_update + ',"city":"' + Appery('city').val() + '"';
                    crud_update = crud_update + ',"region":"' + Appery('region').val() + '"';
                    crud_update = crud_update + ',"phone":"' + Appery('phone').val() + '"';
                    crud_update = '{' + crud_update + '}';
                    localStorage.setItem('psg_update_request', crud_update);
                    //var see_text = localStorage.getItem('psg_update_request');
                    //alert(crud_update);
                    //alert(see_text);
                    try {
                        customer_update.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });

        $('#customer_edit_mobilecontainer [name="cancelbutton"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    closePopup();

                }
            },
        });

    }

    $("#customer_edit").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        customer_edit_beforeshow();
    });

    if (runBeforeShow) {
        customer_edit_beforeshow();
    } else {
        customer_edit_onLoad();
    }

}

$("#customer_edit").die("dialoginit").live("dialoginit", function(event, ui) {
    Appery.processSelectMenu($(this));
    customer_edit_js();
});

$("#customer_edit").die("dialogcreate").live("dialogcreate", function(event, ui) {
    //Most components initializations are done on "pagecreate" event. This event must be triggered for dialogs too.
    $(this).trigger("pagecreate");
});