/*
 * JS for order_detail_edit generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

order_detail_edit_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'productid': 'order_detail_edit_productid',
        'spacer_12': 'order_detail_edit_spacer_12',
        'mobilebutton_25': 'order_detail_edit_mobilebutton_25',
        'spacer_26': 'order_detail_edit_spacer_26',
        'mobilelabel_36': 'order_detail_edit_mobilelabel_36',
        'productname': 'order_detail_edit_productname',
        'mobilegrid_3': 'order_detail_edit_mobilegrid_3',
        'mobilegridcell_4': 'order_detail_edit_mobilegridcell_4',
        'mobilelabel_13': 'order_detail_edit_mobilelabel_13',
        'mobilegridcell_5': 'order_detail_edit_mobilegridcell_5',
        'unitprice': 'order_detail_edit_unitprice',
        'mobilegridcell_6': 'order_detail_edit_mobilegridcell_6',
        'mobilelabel_14': 'order_detail_edit_mobilelabel_14',
        'mobilegridcell_7': 'order_detail_edit_mobilegridcell_7',
        'qty': 'order_detail_edit_qty',
        'mobilegridcell_10': 'order_detail_edit_mobilegridcell_10',
        'mobilelabel_15': 'order_detail_edit_mobilelabel_15',
        'mobilegridcell_11': 'order_detail_edit_mobilegridcell_11',
        'discount': 'order_detail_edit_discount',
        'spacer_19': 'order_detail_edit_spacer_19',
        'spacer_37': 'order_detail_edit_spacer_37',
        'cancelbutton': 'order_detail_edit_cancelbutton',
        'savebutton': 'order_detail_edit_savebutton'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'order_detail_edit';

    /*
     * Nonvisual components
     */
    var datasources = [];

    order_prod_edit = new Appery.DataSource(order_product, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("order_detail_edit");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'order_lines[0]', 'detailid'],
            'ID': '___local_storage___',
            'ATTR': 'detail_ID'
        }, {
            'PATH': ['data', 'order_lines[0]', 'productid'],
            'ID': 'productid',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_lines[0]', 'quantity'],
            'ID': 'qty',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'order_lines[0]', 'discount'],
            'ID': 'discount',
            'ATTR': 'value'
        }, {
            'PATH': ['data', 'order_lines[0]', 'unitprice'],
            'ID': 'unitprice',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_lines[0]', 'productname'],
            'ID': 'productname',
            'ATTR': '@'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['detailid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'detail_ID'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(order_prod_edit);

    delete_product = new Appery.DataSource(psg_delete_orderdetail, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("order_detail_edit");
        },
        'onSuccess': function(data) {
            closePopup();
        },
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['detailid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'detail_ID'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(delete_product);

    update_detail = new Appery.DataSource(psg_update_order_detail, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("order_detail_edit");
        },
        'onSuccess': function(data) {
            closePopup();
        },
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['psg_at_reccord'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'psg_update_request'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(update_detail);

    /*
     * Events and handlers
     */

    // Before Show
    order_detail_edit_beforeshow = function() {
        Appery.CurrentScreen = "order_detail_edit";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_4F19_onLoad = order_detail_edit_onLoad = function() {
        screen_4F19_elementsExtraJS();
        try {
            order_prod_edit.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        order_detail_edit_deviceEvents();
        order_detail_edit_windowEvents();
        screen_4F19_elementsEvents();
    }

    // screen window events
    screen_4F19_windowEvents = order_detail_edit_windowEvents = function() {

        $('#order_detail_edit').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    order_detail_edit_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_4F19_elementsExtraJS = order_detail_edit_elementsExtraJS = function() {
        // screen (order_detail_edit) extra code

    }

    // screen elements handler
    screen_4F19_elementsEvents = order_detail_edit_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#order_detail_edit_mobilecontainer [name="mobilebutton_25"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    try {
                        delete_product.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });

        $('#order_detail_edit_mobilecontainer [name="cancelbutton"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    closePopup();

                }
            },
        });
        $('#order_detail_edit_mobilecontainer [name="savebutton"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    var crud_update = '"detailid":"' + localStorage.getItem('detail_ID') + '"';
                    crud_update = crud_update + ',"productid":"' + Appery('productid').text() + '"';
                    crud_update = crud_update + ',"quantity":' + Appery('qty').val();
                    crud_update = crud_update + ',"discount":' + Appery('discount').val();
                    crud_update = crud_update + ',"unitprice":' + Appery('unitprice').text();
                    crud_update = crud_update + ',"orderid":"' + localStorage.getItem('orderid') + '"';
                    crud_update = '{' + crud_update + '}';
                    localStorage.setItem('psg_update_request', crud_update);
                    //alert(localStorage.getItem('psg_update_request'));
                    try {
                        update_detail.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });

    }

    $("#order_detail_edit").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        order_detail_edit_beforeshow();
    });

    if (runBeforeShow) {
        order_detail_edit_beforeshow();
    } else {
        order_detail_edit_onLoad();
    }

}

$("#order_detail_edit").die("dialoginit").live("dialoginit", function(event, ui) {
    Appery.processSelectMenu($(this));
    order_detail_edit_js();
});

$("#order_detail_edit").die("dialogcreate").live("dialogcreate", function(event, ui) {
    //Most components initializations are done on "pagecreate" event. This event must be triggered for dialogs too.
    $(this).trigger("pagecreate");
});