/*
 * JS for order_details generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

order_details_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'company_details': 'order_details_company_details',
        'mobilecollapsblockheader_16': 'order_details_mobilecollapsblockheader_16',
        'mobilecollapsblockcontent_17': 'order_details_mobilecollapsblockcontent_17',
        'mobilelabel_18': 'order_details_mobilelabel_18',
        'company_address': 'order_details_company_address',
        'mobilelabel_38': 'order_details_mobilelabel_38',
        'ContactName': 'order_details_ContactName',
        'mobilegrid_20': 'order_details_mobilegrid_20',
        'mobilegridcell_21': 'order_details_mobilegridcell_21',
        'mobilelabel_25': 'order_details_mobilelabel_25',
        'city': 'order_details_city',
        'mobilegridcell_22': 'order_details_mobilegridcell_22',
        'mobilelabel_26': 'order_details_mobilelabel_26',
        'phone': 'order_details_phone',
        'ShippToDetails': 'order_details_ShippToDetails',
        'ShippTo': 'order_details_ShippTo',
        'mobilegrid_44': 'order_details_mobilegrid_44',
        'mobilegridcell_45': 'order_details_mobilegridcell_45',
        'label23': 'order_details_label23',
        'ShippToName': 'order_details_ShippToName',
        'mobilecollapsblockcontent_43': 'order_details_mobilecollapsblockcontent_43',
        'mobilelabel_55': 'order_details_mobilelabel_55',
        'shiptoaddress': 'order_details_shiptoaddress',
        'ShipToGrid': 'order_details_ShipToGrid',
        'mobilegridcell_80': 'order_details_mobilegridcell_80',
        'mobilelabel_84': 'order_details_mobilelabel_84',
        'ShipToCity': 'order_details_ShipToCity',
        'mobilegridcell_81': 'order_details_mobilegridcell_81',
        'mobilelabel_86': 'order_details_mobilelabel_86',
        'ShipToPC': 'order_details_ShipToPC',
        'mobilegridcell_82': 'order_details_mobilegridcell_82',
        'mobilelabel_88': 'order_details_mobilelabel_88',
        'ShipToRegion': 'order_details_ShipToRegion',
        'mobilegridcell_83': 'order_details_mobilegridcell_83',
        'mobilelabel_90': 'order_details_mobilelabel_90',
        'ShipToCountry': 'order_details_ShipToCountry',
        'mobilelabel_100': 'order_details_mobilelabel_100',
        'mobilecollapsblock_51': 'order_details_mobilecollapsblock_51',
        'mobilecollapsblockheader_52': 'order_details_mobilecollapsblockheader_52',
        'mobilecollapsblockcontent_53': 'order_details_mobilecollapsblockcontent_53',
        'order_header': 'order_details_order_header',
        'mobilegridcell_6': 'order_details_mobilegridcell_6',
        'mobilelabel_12': 'order_details_mobilelabel_12',
        'OrderDate': 'order_details_OrderDate',
        'mobilegridcell_7': 'order_details_mobilegridcell_7',
        'mobilelabel_14': 'order_details_mobilelabel_14',
        'shippdate': 'order_details_shippdate',
        'EmployeeGrid': 'order_details_EmployeeGrid',
        'mobilegridcell_30': 'order_details_mobilegridcell_30',
        'mobilelabel_36': 'order_details_mobilelabel_36',
        'EmpFirstName': 'order_details_EmpFirstName',
        'mobilegridcell_31': 'order_details_mobilegridcell_31',
        'spacer_40': 'order_details_spacer_40',
        'EmpLastName': 'order_details_EmpLastName',
        'mobilelabel_56': 'order_details_mobilelabel_56',
        'ShipperGRid': 'order_details_ShipperGRid',
        'mobilegridcell_58': 'order_details_mobilegridcell_58',
        'ShipperName': 'order_details_ShipperName',
        'ShipperGrid': 'order_details_ShipperGrid',
        'ShipperPhone': 'order_details_ShipperPhone',
        'ProductsDetails': 'order_details_ProductsDetails',
        'mobilecollapsblockheader_93': 'order_details_mobilecollapsblockheader_93',
        'mobilecollapsblockcontent_94': 'order_details_mobilecollapsblockcontent_94',
        'ProductsHeader': 'order_details_ProductsHeader',
        'mobilegridcell_114': 'order_details_mobilegridcell_114',
        'mobilelabel_120': 'order_details_mobilelabel_120',
        'mobilegridcell_115': 'order_details_mobilegridcell_115',
        'mobilelabel_121': 'order_details_mobilelabel_121',
        'mobilegridcell_118': 'order_details_mobilegridcell_118',
        'QTY': 'order_details_QTY',
        'mobilegridcell_119': 'order_details_mobilegridcell_119',
        'mobilelabel_123': 'order_details_mobilelabel_123',
        'ProductsGrid': 'order_details_ProductsGrid',
        'mobilegridcell_102': 'order_details_mobilegridcell_102',
        'detail_line_button': 'order_details_detail_line_button',
        'detail_ID': 'order_details_detail_ID',
        'mobilegridcell_103': 'order_details_mobilegridcell_103',
        'productname': 'order_details_productname',
        'productid': 'order_details_productid',
        'mobilegridcell_106': 'order_details_mobilegridcell_106',
        'unitprice': 'order_details_unitprice',
        'Discount': 'order_details_Discount',
        'mobilegridcell_107': 'order_details_mobilegridcell_107',
        'quantity': 'order_details_quantity',
        'mobilegridcell_134': 'order_details_mobilegridcell_134',
        'value': 'order_details_value',
        'DValue': 'order_details_DValue',
        'AddNewLine': 'order_details_AddNewLine',
        'OrderTotals': 'order_details_OrderTotals',
        'mobilecollapsblockheader_96': 'order_details_mobilecollapsblockheader_96',
        'OrderTotal': 'order_details_OrderTotal',
        'mobilegrid_124': 'order_details_mobilegrid_124',
        'mobilegridcell_125': 'order_details_mobilegridcell_125',
        'mobilelabel_131': 'order_details_mobilelabel_131',
        'mobilegridcell_126': 'order_details_mobilegridcell_126',
        'TotalValue': 'order_details_TotalValue',
        'mobilegridcell_127': 'order_details_mobilegridcell_127',
        'mobilelabel_132': 'order_details_mobilelabel_132',
        'mobilegridcell_128': 'order_details_mobilegridcell_128',
        'DiscountValue': 'order_details_DiscountValue',
        'mobilegridcell_129': 'order_details_mobilegridcell_129',
        'mobilelabel_133': 'order_details_mobilelabel_133',
        'mobilegridcell_130': 'order_details_mobilegridcell_130',
        'NetValue': 'order_details_NetValue'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'order_details';

    /*
     * Nonvisual components
     */
    var datasources = [];

    order_record = new Appery.DataSource(order_rec, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("order_details");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'order_rec[0]', 'orderdate'],
            'ID': 'OrderDate',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shippeddate'],
            'ID': 'shippdate',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shipname'],
            'ID': 'ShippToName',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shipaddress'],
            'ID': 'shiptoaddress',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shipcity'],
            'ID': 'ShipToCity',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shipregion'],
            'ID': 'ShipToRegion',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shippostalcode'],
            'ID': 'ShipToPC',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shipcountry'],
            'ID': 'ShipToCountry',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'companyname'],
            'ID': 'mobilecollapsblockheader_16',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'city'],
            'ID': 'city',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'phone'],
            'ID': 'phone',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'address'],
            'ID': 'company_address',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'contactname'],
            'ID': 'ContactName',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shipper'],
            'ID': 'ShipperName',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'shippphone'],
            'ID': 'ShipperPhone',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'firstname'],
            'ID': 'EmpFirstName',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'lastname'],
            'ID': 'EmpLastName',
            'ATTR': '@'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['orderid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'orderid'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(order_record);

    order_details = new Appery.DataSource(order_lines, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("order_details");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'order_lines'],
            'ID': 'ProductsGrid',
            'SET': [{
                'PATH': ['detailid'],
                'ID': 'detail_ID',
                'ATTR': '@'
            }, {
                'PATH': ['productid'],
                'ID': 'productid',
                'ATTR': '@'
            }, {
                'PATH': ['quantity'],
                'ID': 'quantity',
                'ATTR': '@'
            }, {
                'PATH': ['discount'],
                'ID': 'Discount',
                'ATTR': '@'
            }, {
                'PATH': ['unitprice'],
                'ID': 'unitprice',
                'ATTR': '@'
            }, {
                'PATH': ['productname'],
                'ID': 'productname',
                'ATTR': '@'
            }, {
                'PATH': ['value'],
                'ID': 'value',
                'ATTR': '@'
            }, {
                'PATH': ['dvalue'],
                'ID': 'DValue',
                'ATTR': '@'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['orderid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'orderid'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(order_details);

    order_totals = new Appery.DataSource(order_total, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("order_details");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'order_rec[0]', 'tvalue'],
            'ID': 'TotalValue',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'tdvalue'],
            'ID': 'DiscountValue',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_rec[0]', 'netvalue'],
            'ID': 'NetValue',
            'ATTR': '@'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['orderid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'orderid'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(order_totals);

    /*
     * Events and handlers
     */

    // Before Show
    order_details_beforeshow = function() {
        Appery.CurrentScreen = "order_details";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_A02D_onLoad = order_details_onLoad = function() {
        screen_A02D_elementsExtraJS();

        // TODO fire device events only if necessary (with JS logic)
        order_details_deviceEvents();
        order_details_windowEvents();
        screen_A02D_elementsEvents();
    }

    // screen window events
    screen_A02D_windowEvents = order_details_windowEvents = function() {

        $('#order_details').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });
        $('#order_details').bind({
            pageshow: function() {
                try {
                    order_record.execute({})
                } catch (ex) {
                    console.log(ex.name + '  ' + ex.message);
                    hideSpinner();
                };
                try {
                    order_details.execute({})
                } catch (ex) {
                    console.log(ex.name + '  ' + ex.message);
                    hideSpinner();
                };
                try {
                    order_totals.execute({})
                } catch (ex) {
                    console.log(ex.name + '  ' + ex.message);
                    hideSpinner();
                };
            },
        });

    }

    // device events
    order_details_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_A02D_elementsExtraJS = order_details_elementsExtraJS = function() {
        // screen (order_details) extra code

        /* company_details */

        $("#order_details_company_details .ui-collapsible-heading-toggle").attr("tabindex", "1");

        /* ShippToDetails */

        $("#order_details_ShippToDetails .ui-collapsible-heading-toggle").attr("tabindex", "2");

        /* mobilecollapsblock_51 */

        $("#order_details_mobilecollapsblock_51 .ui-collapsible-heading-toggle").attr("tabindex", "3");

        /* ProductsDetails */

        $("#order_details_ProductsDetails .ui-collapsible-heading-toggle").attr("tabindex", "4");

        /* OrderTotals */

        $("#order_details_OrderTotals .ui-collapsible-heading-toggle").attr("tabindex", "5");

    }

    // screen elements handler
    screen_A02D_elementsEvents = order_details_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#order_details_OrderDetails [name="detail_line_button"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    setVar_('detail_ID', 'order_details_detail_ID', 'text', '', this);
                    setVar_('productid', 'order_details_productid', 'text', '', this);
                    setVar_('productname', 'order_details_productname', 'text', '', this);
                    Appery.navigateTo('order_detail_edit', {
                        transition: 'pop'
                    });

                }
            },
        });

        $('#order_details_OrderDetails [name="AddNewLine"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    Appery.navigateTo('Order_New_Line2', {
                        transition: 'pop'
                    });

                }
            },
        });

    }

    $("#order_details").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        order_details_beforeshow();
    });

    if (runBeforeShow) {
        order_details_beforeshow();
    } else {
        order_details_onLoad();
    }

}

$("#order_details").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    order_details_js();
});