/*
 * JS for order_pdet generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

order_pdet_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'Detail_ID': 'order_pdet_Detail_ID',
        'prodid': 'order_pdet_prodid',
        'product_combo': 'order_pdet_product_combo',
        'mobileselectmenuitem_6': 'order_pdet_mobileselectmenuitem_6'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'order_pdet';

    /*
     * Nonvisual components
     */
    var datasources = [];

    product_line = new Appery.DataSource(order_product, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("order_pdet");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'order_lines[0]', 'detailid'],
            'ID': 'Detail_ID',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_lines[0]', 'productid'],
            'ID': 'prodid',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'order_lines[0]', 'productid'],
            'ID': 'product_combo',
            'ATTR': 'value'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['detailid'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'detail_ID'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(product_line);

    prod_list = new Appery.DataSource(products, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("order_pdet");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'products'],
            'ID': 'product_combo-0',
            'SET': [{
                'PATH': ['productid'],
                'ID': 'product_combo-0',
                'ATTR': 'value'
            }, {
                'PATH': ['productname'],
                'ID': 'product_combo-0',
                'ATTR': '@'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(prod_list);

    /*
     * Events and handlers
     */

    // Before Show
    order_pdet_beforeshow = function() {
        Appery.CurrentScreen = "order_pdet";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_D7F7_onLoad = order_pdet_onLoad = function() {
        screen_D7F7_elementsExtraJS();
        try {
            product_line.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };
        try {
            prod_list.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        order_pdet_deviceEvents();
        order_pdet_windowEvents();
        screen_D7F7_elementsEvents();
    }

    // screen window events
    screen_D7F7_windowEvents = order_pdet_windowEvents = function() {

        $('#order_pdet').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    order_pdet_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_D7F7_elementsExtraJS = order_pdet_elementsExtraJS = function() {
        // screen (order_pdet) extra code

        /* product_combo */

        $("#order_pdet_product_combo").parent().find("a.ui-btn").attr("tabindex", "1");

    }

    // screen elements handler
    screen_D7F7_elementsEvents = order_pdet_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

    }

    $("#order_pdet").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        order_pdet_beforeshow();
    });

    if (runBeforeShow) {
        order_pdet_beforeshow();
    } else {
        order_pdet_onLoad();
    }

}

$("#order_pdet").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    order_pdet_js();
});