/*
 * JS for orders_list generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

orders_list_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'orders_list_by_month': 'orders_list_orders_list_by_month',
        'order': 'orders_list_order',
        'mobilelistitembutton_3': 'orders_list_mobilelistitembutton_3',
        'companyname': 'orders_list_companyname',
        'orderdate': 'orders_list_orderdate',
        'orderid_': 'orders_list_orderid_'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'orders_list';

    /*
     * Nonvisual components
     */
    var datasources = [];

    orders_list_ = new Appery.DataSource(orders_list, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("orders_list");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'orders_list'],
            'ID': 'order',
            'SET': [{
                'PATH': ['orderid'],
                'ID': 'orderid_',
                'ATTR': '@'
            }, {
                'PATH': ['orderdate'],
                'ID': 'orderdate',
                'ATTR': '@'
            }, {
                'PATH': ['companyname'],
                'ID': 'companyname',
                'ATTR': '@'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['month_string'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'month_string'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(orders_list_);

    /*
     * Events and handlers
     */

    // Before Show
    orders_list_beforeshow = function() {
        Appery.CurrentScreen = "orders_list";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_FEE0_onLoad = orders_list_onLoad = function() {
        screen_FEE0_elementsExtraJS();

        // TODO fire device events only if necessary (with JS logic)
        orders_list_deviceEvents();
        orders_list_windowEvents();
        screen_FEE0_elementsEvents();
    }

    // screen window events
    screen_FEE0_windowEvents = orders_list_windowEvents = function() {

        $('#orders_list').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });
        $('#orders_list').bind({
            pageshow: function() {
                try {
                    orders_list_.execute({})
                } catch (ex) {
                    console.log(ex.name + '  ' + ex.message);
                    hideSpinner();
                };
            },
        });

    }

    // device events
    orders_list_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_FEE0_elementsExtraJS = orders_list_elementsExtraJS = function() {
        // screen (orders_list) extra code

        /* orders_list_by_month */

        listView = $("#orders_list_orders_list_by_month");
        theme = listView.attr("data-theme");
        if (typeof theme !== 'undefined') {
            var themeClass = "ui-btn-up-" + theme;
            listItem = $("#orders_list_orders_list_by_month .ui-li-static");
            $.each(listItem, function(index, value) {
                $(this).addClass(themeClass);
            });
        }

        /* order */

    }

    // screen elements handler
    screen_FEE0_elementsEvents = orders_list_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#orders_list_mobilecontainer [name="order"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    setVar_('orderid', 'orders_list_orderid_', 'text', '', this);
                    Appery.navigateTo('order_details', {
                        reverse: false
                    });

                }
            },
        });

    }

    $("#orders_list").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        orders_list_beforeshow();
    });

    if (runBeforeShow) {
        orders_list_beforeshow();
    } else {
        orders_list_onLoad();
    }

}

$("#orders_list").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    orders_list_js();
});