/*
 * JS for product generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

product_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'mobilelabel_1': 'product_mobilelabel_1',
        'productname': 'product_productname',
        'spacer_16': 'product_spacer_16',
        'mobilelabel_3': 'product_mobilelabel_3',
        'qtyperunit': 'product_qtyperunit',
        'spacer_14': 'product_spacer_14',
        'checkboxgroup': 'product_checkboxgroup',
        'discontinued': 'product_discontinued',
        'spacer_15': 'product_spacer_15',
        'mobilelabel_17': 'product_mobilelabel_17',
        'unitprice': 'product_unitprice',
        'spacer_13': 'product_spacer_13',
        'closebutton': 'product_closebutton'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'product';

    /*
     * Nonvisual components
     */
    var datasources = [];

    product_reccord = new Appery.DataSource(search_product, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("product");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'search_result[0]', 'productname'],
            'ID': 'productname',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'search_result[0]', 'quantityperunit'],
            'ID': 'qtyperunit',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'search_result[0]', 'discontinued'],
            'ID': 'discontinued',
            'ATTR': 'checked'
        }, {
            'PATH': ['data', 'search_result[0]', 'unitprice'],
            'ID': 'unitprice',
            'ATTR': '@'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'TYPE': 'STRING',
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'authorization_string'
        }, {
            'PATH': ['table_name'],
            'TYPE': 'STRING',
            'ATTR': 'products'
        }, {
            'PATH': ['key_value'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'productid'
        }, {
            'PATH': ['primary_key'],
            'TYPE': 'STRING',
            'ATTR': 'productid'
        }, {
            'PATH': ['url'],
            'TYPE': 'STRING',
            'ID': '___local_storage___',
            'ATTR': 'url'
        }]
    });

    datasources.push(product_reccord);

    /*
     * Events and handlers
     */

    // Before Show
    product_beforeshow = function() {
        Appery.CurrentScreen = "product";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_A0D8_onLoad = product_onLoad = function() {
        screen_A0D8_elementsExtraJS();
        try {
            product_reccord.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        product_deviceEvents();
        product_windowEvents();
        screen_A0D8_elementsEvents();
    }

    // screen window events
    screen_A0D8_windowEvents = product_windowEvents = function() {

        $('#product').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    product_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_A0D8_elementsExtraJS = product_elementsExtraJS = function() {
        // screen (product) extra code

    }

    // screen elements handler
    screen_A0D8_elementsEvents = product_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#product_mobilecontainer [name="closebutton"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    closePopup();

                }
            },
        });

    }

    $("#product").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        product_beforeshow();
    });

    if (runBeforeShow) {
        product_beforeshow();
    } else {
        product_onLoad();
    }

}

$("#product").die("dialoginit").live("dialoginit", function(event, ui) {
    Appery.processSelectMenu($(this));
    product_js();
});

$("#product").die("dialogcreate").live("dialogcreate", function(event, ui) {
    //Most components initializations are done on "pagecreate" event. This event must be triggered for dialogs too.
    $(this).trigger("pagecreate");
});