/*
 * JS for start_menu generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '650da51c-7b87-423e-b67d-61d28cf28805';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "order_pdet",
    "location": "order_pdet.html"
}, {
    "name": "Order_New_Line",
    "location": "Order_New_Line.html"
}, {
    "name": "update_error",
    "location": "update_error.html"
}, {
    "name": "test_pb",
    "location": "test_pb.html"
}, {
    "name": "orders_sel",
    "location": "orders_sel.html"
}, {
    "name": "Camera",
    "location": "Camera.html"
}, {
    "name": "orders_list",
    "location": "orders_list.html"
}, {
    "name": "Camera_cl2",
    "location": "Camera_cl2.html"
}, {
    "name": "order_details",
    "location": "order_details.html"
}, {
    "name": "customer_details",
    "location": "customer_details.html"
}, {
    "name": "Products",
    "location": "Products.html"
}, {
    "name": "start_menu",
    "location": "start_menu.html"
}, {
    "name": "product",
    "location": "product.html"
}, {
    "name": "Order_New_Line2",
    "location": "Order_New_Line2.html"
}, {
    "name": "startScreen",
    "location": "startScreen.html"
}, {
    "name": "order_detail_edit",
    "location": "order_detail_edit.html"
}, {
    "name": "Customers",
    "location": "Customers.html"
}, {
    "name": "customer_edit",
    "location": "customer_edit.html"
}, {
    "name": "create_order",
    "location": "create_order.html"
}];

start_menu_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'spacer_12': 'start_menu_spacer_12',
        'customers_button': 'start_menu_customers_button',
        'Products_button': 'start_menu_Products_button',
        'Orders_button': 'start_menu_Orders_button',
        'spacer_1': 'start_menu_spacer_1',
        'mobilelabel_2': 'start_menu_mobilelabel_2',
        'mobilelabel_8': 'start_menu_mobilelabel_8',
        'mobilelabel_9': 'start_menu_mobilelabel_9',
        'mobilelabel_10': 'start_menu_mobilelabel_10',
        'spacer_5': 'start_menu_spacer_5',
        'mobilelabel_6': 'start_menu_mobilelabel_6',
        'mobilelabel_7': 'start_menu_mobilelabel_7',
        'mobilebutton_13': 'start_menu_mobilebutton_13',
        'mobilebutton_14': 'start_menu_mobilebutton_14',
        'mobilebutton_15': 'start_menu_mobilebutton_15'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=page] div[data-role=footer]").css("bottom", "-36px");
    }

    if (Appery.getTargetPlatform == "I") {
        $.each(window.n2id, function(name, id) {
            var elApperyRole = $("#" + id).attr("data-role");
            if (elApperyRole != "appery_label" && elApperyRole != "appery_link") {
                var appleDataSelector = "#" + id + "[x-apple-data-detectors], #" + id + " [x-apple-data-detectors]";
                $(appleDataSelector).attr("x-apple-data-detectors", "false");
            }
        });
    }

    Appery.CurrentScreen = 'start_menu';

    /*
     * Nonvisual components
     */
    var datasources = [];

    /*
     * Events and handlers
     */

    // Before Show
    start_menu_beforeshow = function() {
        Appery.CurrentScreen = "start_menu";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_78E3_onLoad = start_menu_onLoad = function() {
        screen_78E3_elementsExtraJS();

        // TODO fire device events only if necessary (with JS logic)
        start_menu_deviceEvents();
        start_menu_windowEvents();
        screen_78E3_elementsEvents();
    }

    // screen window events
    screen_78E3_windowEvents = start_menu_windowEvents = function() {

        $('#start_menu').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    start_menu_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_78E3_elementsExtraJS = start_menu_elementsExtraJS = function() {
        // screen (start_menu) extra code

    }

    // screen elements handler
    screen_78E3_elementsEvents = start_menu_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#start_menu_mobilecontainer [name="customers_button"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    Appery.navigateTo('Customers', {
                        reverse: false
                    });

                }
            },
        });
        $('#start_menu_mobilecontainer [name="Products_button"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    Appery.navigateTo('Products', {
                        reverse: false
                    });

                }
            },
        });
        $('#start_menu_mobilecontainer [name="Orders_button"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    Appery.navigateTo('orders_sel', {
                        reverse: false
                    });

                }
            },
        });

        $('#start_menu_mobilecontainer [name="mobilebutton_13"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    Appery.navigateTo('Camera', {
                        reverse: false
                    });

                }
            },
        });
        $('#start_menu_mobilecontainer [name="mobilebutton_14"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    Appery.navigateTo('Camera_cl2', {
                        reverse: false
                    });

                }
            },
        });
        $('#start_menu_mobilecontainer [name="mobilebutton_15"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    var devicePlatform = device.platform;
                    alert(devicePlatform);

                }
            },
        });

    }

    $("#start_menu").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        start_menu_beforeshow();
    });

    if (runBeforeShow) {
        start_menu_beforeshow();
    } else {
        start_menu_onLoad();
    }

}

$("#start_menu").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    start_menu_js();
});