/*
 * JS for ApiPage generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '1c0ae847-f0fd-4b68-97b2-853cc35aa54f';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "EditService",
    "location": "EditService.html"
}, {
    "name": "ApiPage",
    "location": "ApiPage.html"
}, {
    "name": "test",
    "location": "test.html"
}, {
    "name": "StartPage",
    "location": "StartPage.html"
}, {
    "name": "StartScreen",
    "location": "StartScreen.html"
}, {
    "name": "table_details",
    "location": "table_details.html"
}, {
    "name": "servicelist",
    "location": "servicelist.html"
}, {
    "name": "Database",
    "location": "Database.html"
}, {
    "name": "StartApp",
    "location": "StartApp.html"
}, {
    "name": "serverinformation",
    "location": "serverinformation.html"
}];

$(document).bind('scroll', function() {
    adjustContentHeight();
});
$(window).bind(window.orientation ? 'orientationchange' : 'resize', function() {
    adjustContentHeight();
});

ApiPage_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'categories': 'ApiPage_categories',
        'category': 'ApiPage_category',
        'mobilelistitembutton_4': 'ApiPage_mobilelistitembutton_4'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=footer]").css("bottom", "-36px");
    }

    Appery.CurrentScreen = 'ApiPage';

    /*
     * Nonvisual components
     */
    var datasources = [];

    cat_list = new Appery.DataSource(categories, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("ApiPage");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'apicategories'],
            'ID': 'category',
            'SET': [{
                'PATH': ['category'],
                'ID': 'category',
                'ATTR': '@',
                'SUBSELECTOR': 'h3.ui-li-heading'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'Authorization_string'
        }]
    });

    datasources.push(cat_list);

    services_list = new Appery.DataSource(listse, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("ApiPage");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {
            alert('error loading data');
        },
        'responseMapping': [],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'Authorization_string'
        }, {
            'PATH': ['categoryname'],
            'ID': 'category',
            'ATTR': '@',
            'SUBSELECTOR': 'h3.ui-li-heading'
        }]
    });

    datasources.push(services_list);

    /*
     * Events and handlers
     */

    // Before Show
    ApiPage_beforeshow = function() {
        Appery.CurrentScreen = "ApiPage";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_DB0C_onLoad = ApiPage_onLoad = function() {
        screen_DB0C_elementsExtraJS();
        try {
            cat_list.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };
        try {
            services_list.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        ApiPage_deviceEvents();
        ApiPage_windowEvents();
        screen_DB0C_elementsEvents();
    }

    // screen window events
    screen_DB0C_windowEvents = ApiPage_windowEvents = function() {
        $('#ApiPage').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    ApiPage_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_DB0C_elementsExtraJS = ApiPage_elementsExtraJS = function() {
        // screen (ApiPage) extra code

        /* categories */

        listView = $("#ApiPage_categories");
        theme = listView.attr("data-theme");
        if (typeof theme !== 'undefined') {
            var themeClass = "ui-btn-up-" + theme;
            listItem = $("#ApiPage_categories .ui-li-static");
            $.each(listItem, function(index, value) {
                $(this).addClass(themeClass);
            });
        }

        /* category */

    }

    // screen elements handler
    screen_DB0C_elementsEvents = ApiPage_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#ApiPage_mobilecontainer [name="category"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    setVar_('select_category', 'ApiPage_category', 'text', '', this);
                    setDetailContent('servicelist.html');

                }
            },
        });

    }

    $("#ApiPage").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        ApiPage_beforeshow();
    });

    if ($(window).width() >= 650) {
        var fixed = true;

        jQuery(document).ready(function($) {
            $('.ui-content').addClass("width_gt_650");

            if (navigator.platform == 'iPad' || navigator.platform == 'iPhone' || navigator.platform == 'iPod') {
                $(".content-secondary").css("position", "absolute");
                fixed = false;
            } else {
                $(".content-secondary").css("position", "fixed");
            }

            $(".content-secondary").css("float", "left");
            $(".content-secondary").css("left", "0px");
            var heightEl = $(".ui-header:visible");
            $(".content-secondary").css("top", heightEl.outerHeight() ? heightEl.outerHeight() : 0 + "px");
            $(".content-secondary").css("z-index", "999");
            $(".content-secondary").css("border", "0px solid red");

            adjustContentHeight();
        });

        $('.content-secondary input, .content-secondary textarea').unbind('blur', adjustContentHeight);
        $('.content-secondary input, .content-secondary textarea').bind('blur', adjustContentHeight);

        $("#ApiPage").bind("pageshow", function(event) {
            var $page = $(this);
            $page.find(":jqmData(scroll):not(.ui-scrollview-clip)").each(function() {
                var $this = $(this);
                // XXX: Remove this check for ui-scrolllistview once we've
                //      integrated list divider support into the main scrollview class.
                if ($this.hasClass("ui-scrolllistview")) $this.scrolllistview();
                else {
                    var st = $this.jqmData("scroll") + "";
                    var paging = st && st.search(/^[xy]p$/) != -1;
                    var dir = st && st.search(/^[xy]/) != -1 ? st.charAt(0) : null;

                    var opts = {};
                    if (dir) opts.direction = dir;
                    if (paging) opts.pagingEnabled = true;

                    var method = $this.jqmData("scroll-method");
                    if (method) opts.scrollMethod = method;

                    $this.scrollview(opts);
                }
            });
        });

    }

    if (runBeforeShow) {
        ApiPage_beforeshow();
    } else {
        ApiPage_onLoad();
    }

}

$("#ApiPage").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    ApiPage_js();
});