/*
 * JS for Database generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '1c0ae847-f0fd-4b68-97b2-853cc35aa54f';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "EditService",
    "location": "EditService.html"
}, {
    "name": "ApiPage",
    "location": "ApiPage.html"
}, {
    "name": "test",
    "location": "test.html"
}, {
    "name": "StartPage",
    "location": "StartPage.html"
}, {
    "name": "StartScreen",
    "location": "StartScreen.html"
}, {
    "name": "table_details",
    "location": "table_details.html"
}, {
    "name": "servicelist",
    "location": "servicelist.html"
}, {
    "name": "Database",
    "location": "Database.html"
}, {
    "name": "StartApp",
    "location": "StartApp.html"
}, {
    "name": "serverinformation",
    "location": "serverinformation.html"
}];

$(document).bind('scroll', function() {
    adjustContentHeight();
});
$(window).bind(window.orientation ? 'orientationchange' : 'resize', function() {
    adjustContentHeight();
});

Database_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'tlist': 'Database_tlist',
        'mobilelistitem_22': 'Database_mobilelistitem_22',
        'mobilelistitembutton_23': 'Database_mobilelistitembutton_23'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=footer]").css("bottom", "-36px");
    }

    Appery.CurrentScreen = 'Database';

    /*
     * Nonvisual components
     */
    var datasources = [];

    tables_list = new Appery.DataSource(tables, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("Database");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'tables'],
            'ID': 'mobilelistitem_22',
            'SET': [{
                'PATH': ['tablename'],
                'ID': 'mobilelistitem_22',
                'ATTR': '@',
                'SUBSELECTOR': 'h3.ui-li-heading'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'Authorization_string'
        }]
    });

    datasources.push(tables_list);

    /*
     * Events and handlers
     */

    // Before Show
    Database_beforeshow = function() {
        Appery.CurrentScreen = "Database";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_56BC_onLoad = Database_onLoad = function() {
        screen_56BC_elementsExtraJS();
        try {
            tables_list.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        Database_deviceEvents();
        Database_windowEvents();
        screen_56BC_elementsEvents();
    }

    // screen window events
    screen_56BC_windowEvents = Database_windowEvents = function() {
        $('#Database').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    Database_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_56BC_elementsExtraJS = Database_elementsExtraJS = function() {
        // screen (Database) extra code

        /* tlist */

        listView = $("#Database_tlist");
        theme = listView.attr("data-theme");
        if (typeof theme !== 'undefined') {
            var themeClass = "ui-btn-up-" + theme;
            listItem = $("#Database_tlist .ui-li-static");
            $.each(listItem, function(index, value) {
                $(this).addClass(themeClass);
            });
        }

        /* mobilelistitem_22 */

    }

    // screen elements handler
    screen_56BC_elementsEvents = Database_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#Database_mobilecontainer [name="mobilelistitem_22"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    setVar_('selected_table', 'Database_mobilelistitem_22', 'text', '', this);
                    setDetailContent('table_details.html');

                }
            },
        });

    }

    $("#Database").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        Database_beforeshow();
    });

    if ($(window).width() >= 650) {
        var fixed = true;

        jQuery(document).ready(function($) {
            $('.ui-content').addClass("width_gt_650");

            if (navigator.platform == 'iPad' || navigator.platform == 'iPhone' || navigator.platform == 'iPod') {
                $(".content-secondary").css("position", "absolute");
                fixed = false;
            } else {
                $(".content-secondary").css("position", "fixed");
            }

            $(".content-secondary").css("float", "left");
            $(".content-secondary").css("left", "0px");
            var heightEl = $(".ui-header:visible");
            $(".content-secondary").css("top", heightEl.outerHeight() ? heightEl.outerHeight() : 0 + "px");
            $(".content-secondary").css("z-index", "999");
            $(".content-secondary").css("border", "0px solid red");

            adjustContentHeight();
        });

        $('.content-secondary input, .content-secondary textarea').unbind('blur', adjustContentHeight);
        $('.content-secondary input, .content-secondary textarea').bind('blur', adjustContentHeight);

        $("#Database").bind("pageshow", function(event) {
            var $page = $(this);
            $page.find(":jqmData(scroll):not(.ui-scrollview-clip)").each(function() {
                var $this = $(this);
                // XXX: Remove this check for ui-scrolllistview once we've
                //      integrated list divider support into the main scrollview class.
                if ($this.hasClass("ui-scrolllistview")) $this.scrolllistview();
                else {
                    var st = $this.jqmData("scroll") + "";
                    var paging = st && st.search(/^[xy]p$/) != -1;
                    var dir = st && st.search(/^[xy]/) != -1 ? st.charAt(0) : null;

                    var opts = {};
                    if (dir) opts.direction = dir;
                    if (paging) opts.pagingEnabled = true;

                    var method = $this.jqmData("scroll-method");
                    if (method) opts.scrollMethod = method;

                    $this.scrollview(opts);
                }
            });
        });

    }

    if (runBeforeShow) {
        Database_beforeshow();
    } else {
        Database_onLoad();
    }

}

$("#Database").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    Database_js();
});