/*
 * JS for StartScreen generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '1c0ae847-f0fd-4b68-97b2-853cc35aa54f';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "EditService",
    "location": "EditService.html"
}, {
    "name": "ApiPage",
    "location": "ApiPage.html"
}, {
    "name": "test",
    "location": "test.html"
}, {
    "name": "StartPage",
    "location": "StartPage.html"
}, {
    "name": "StartScreen",
    "location": "StartScreen.html"
}, {
    "name": "table_details",
    "location": "table_details.html"
}, {
    "name": "servicelist",
    "location": "servicelist.html"
}, {
    "name": "Database",
    "location": "Database.html"
}, {
    "name": "StartApp",
    "location": "StartApp.html"
}, {
    "name": "serverinformation",
    "location": "serverinformation.html"
}];

$(document).bind('scroll', function() {
    adjustContentHeight();
});
$(window).bind(window.orientation ? 'orientationchange' : 'resize', function() {
    adjustContentHeight();
});

StartScreen_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'spacer_24': 'StartScreen_spacer_24',
        'mobilelabel_23': 'StartScreen_mobilelabel_23',
        'spacer_22': 'StartScreen_spacer_22',
        'spacer_21': 'StartScreen_spacer_21',
        'mobilegrid_25': 'StartScreen_mobilegrid_25',
        'mobilegridcell_26': 'StartScreen_mobilegridcell_26',
        'logingrid': 'StartScreen_logingrid',
        'mobilegridcell_13': 'StartScreen_mobilegridcell_13',
        'mobilelabel_17': 'StartScreen_mobilelabel_17',
        'mobilegridcell_14': 'StartScreen_mobilegridcell_14',
        'AdminIn': 'StartScreen_AdminIn',
        'mobilegridcell_15': 'StartScreen_mobilegridcell_15',
        'mobilelabel_18': 'StartScreen_mobilelabel_18',
        'mobilegridcell_16': 'StartScreen_mobilegridcell_16',
        'password': 'StartScreen_password',
        'mobilegridcell_27': 'StartScreen_mobilegridcell_27',
        'mobilegridcell_28': 'StartScreen_mobilegridcell_28',
        'mobilebutton_10': 'StartScreen_mobilebutton_10',
        'mobilegridcell_29': 'StartScreen_mobilegridcell_29',
        'auth_string_text': 'StartScreen_auth_string_text',
        'mobilegridcell_31': 'StartScreen_mobilegridcell_31',
        'mobilegridcell_32': 'StartScreen_mobilegridcell_32',
        'mobilegridcell_33': 'StartScreen_mobilegridcell_33',
        'login_message': 'StartScreen_login_message',
        'mobilegridcell_34': 'StartScreen_mobilegridcell_34',
        'spacer_36': 'StartScreen_spacer_36',
        'mobileimage_37': 'StartScreen_mobileimage_37'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=footer]").css("bottom", "-36px");
    }

    Appery.CurrentScreen = 'StartScreen';

    /*
     * Nonvisual components
     */
    var datasources = [];

    authorization_data = new Appery.DataSource(Authorization, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("StartScreen");
        },
        'onSuccess': function(data) {
            setText('StartScreen_login_message', 'Login OK');
            Appery.navigateTo('StartApp', {
                transition: 'slide',
                reverse: false
            });
        },
        'onError': function(jqXHR, textStatus, errorThrown) {
            setText('StartScreen_login_message', 'Login failed');
        },
        'responseMapping': [],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'Authorization_string'
        }]
    });

    datasources.push(authorization_data);

    /*
     * Events and handlers
     */

    // Before Show
    StartScreen_beforeshow = function() {
        Appery.CurrentScreen = "StartScreen";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_63B9_onLoad = StartScreen_onLoad = function() {
        screen_63B9_elementsExtraJS();

        // TODO fire device events only if necessary (with JS logic)
        StartScreen_deviceEvents();
        StartScreen_windowEvents();
        screen_63B9_elementsEvents();
    }

    // screen window events
    screen_63B9_windowEvents = StartScreen_windowEvents = function() {
        $('#StartScreen').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });
        $('#StartScreen').bind({
            pageshow: function() {
                setDetailContent('StartPage.html');
            },
        });

    }

    // device events
    StartScreen_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_63B9_elementsExtraJS = StartScreen_elementsExtraJS = function() {
        // screen (StartScreen) extra code

    }

    // screen elements handler
    screen_63B9_elementsEvents = StartScreen_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#StartScreen_mobilecontainer2 [name="AdminIn"]').die().live({
            change: function() {
                setText('StartScreen_AdminIn', 'Adminstrator');
            },
        });

        $('#StartScreen_mobilecontainer2 [name="mobilebutton_10"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    setVar_('user_temp', 'StartScreen_AdminIn', 'text', '', this);
                    setVar_('password_string', 'StartScreen_password', 'text', '', this);
                    var auth_string = localStorage.getItem('user_temp') + ':' + localStorage.getItem('password_string');
                    $('[dsid="auth_string_text"]').text(getAuth(auth_string));
                    setVar_('Authorization_string', 'StartScreen_auth_string_text', 'text', '', this);
                    try {
                        authorization_data.execute({})
                    } catch (ex) {
                        console.log(ex.name + '  ' + ex.message);
                        hideSpinner();
                    };

                }
            },
        });

    }

    $("#StartScreen").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        StartScreen_beforeshow();
    });

    if ($(window).width() >= 650) {
        var fixed = true;

        jQuery(document).ready(function($) {
            $('.ui-content').addClass("width_gt_650");

            if (navigator.platform == 'iPad' || navigator.platform == 'iPhone' || navigator.platform == 'iPod') {
                $(".content-secondary").css("position", "absolute");
                fixed = false;
            } else {
                $(".content-secondary").css("position", "fixed");
            }

            $(".content-secondary").css("float", "left");
            $(".content-secondary").css("left", "0px");
            var heightEl = $(".ui-header:visible");
            $(".content-secondary").css("top", heightEl.outerHeight() ? heightEl.outerHeight() : 0 + "px");
            $(".content-secondary").css("z-index", "999");
            $(".content-secondary").css("border", "0px solid red");

            adjustContentHeight();
        });

        $('.content-secondary input, .content-secondary textarea').unbind('blur', adjustContentHeight);
        $('.content-secondary input, .content-secondary textarea').bind('blur', adjustContentHeight);

        $("#StartScreen").bind("pageshow", function(event) {
            var $page = $(this);
            $page.find(":jqmData(scroll):not(.ui-scrollview-clip)").each(function() {
                var $this = $(this);
                // XXX: Remove this check for ui-scrolllistview once we've
                //      integrated list divider support into the main scrollview class.
                if ($this.hasClass("ui-scrolllistview")) $this.scrolllistview();
                else {
                    var st = $this.jqmData("scroll") + "";
                    var paging = st && st.search(/^[xy]p$/) != -1;
                    var dir = st && st.search(/^[xy]/) != -1 ? st.charAt(0) : null;

                    var opts = {};
                    if (dir) opts.direction = dir;
                    if (paging) opts.pagingEnabled = true;

                    var method = $this.jqmData("scroll-method");
                    if (method) opts.scrollMethod = method;

                    $this.scrollview(opts);
                }
            });
        });

    }
    $("#StartScreen").bind('pageshow', function() {
        setDetailContent('StartPage.html')
    });

    if (runBeforeShow) {
        StartScreen_beforeshow();
    } else {
        StartScreen_onLoad();
    }

}

$("#StartScreen").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    StartScreen_js();
});