/*
 * JS for serverinformation generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '1c0ae847-f0fd-4b68-97b2-853cc35aa54f';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "EditService",
    "location": "EditService.html"
}, {
    "name": "ApiPage",
    "location": "ApiPage.html"
}, {
    "name": "test",
    "location": "test.html"
}, {
    "name": "StartPage",
    "location": "StartPage.html"
}, {
    "name": "StartScreen",
    "location": "StartScreen.html"
}, {
    "name": "table_details",
    "location": "table_details.html"
}, {
    "name": "servicelist",
    "location": "servicelist.html"
}, {
    "name": "Database",
    "location": "Database.html"
}, {
    "name": "StartApp",
    "location": "StartApp.html"
}, {
    "name": "serverinformation",
    "location": "serverinformation.html"
}];

$(document).bind('scroll', function() {
    adjustContentHeight();
});
$(window).bind(window.orientation ? 'orientationchange' : 'resize', function() {
    adjustContentHeight();
});

serverinformation_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'serverinfo': 'serverinformation_serverinfo',
        'mobilegridcell_6': 'serverinformation_mobilegridcell_6',
        'mobilelabel_32': 'serverinformation_mobilelabel_32',
        'mobilegridcell_7': 'serverinformation_mobilegridcell_7',
        'company': 'serverinformation_company',
        'mobilegridcell_8': 'serverinformation_mobilegridcell_8',
        'mobilelabel_24': 'serverinformation_mobilelabel_24',
        'mobilegridcell_9': 'serverinformation_mobilegridcell_9',
        'software': 'serverinformation_software',
        'mobilegridcell_10': 'serverinformation_mobilegridcell_10',
        'mobilelabel_30': 'serverinformation_mobilelabel_30',
        'mobilegridcell_11': 'serverinformation_mobilegridcell_11',
        'ApplicationID': 'serverinformation_ApplicationID',
        'mobilegridcell_12': 'serverinformation_mobilegridcell_12',
        'mobilelabel_25': 'serverinformation_mobilelabel_25',
        'mobilegridcell_13': 'serverinformation_mobilegridcell_13',
        'provider': 'serverinformation_provider',
        'mobilegridcell_14': 'serverinformation_mobilegridcell_14',
        'mobilelabel_31': 'serverinformation_mobilelabel_31',
        'mobilegridcell_15': 'serverinformation_mobilegridcell_15',
        'ProviderID': 'serverinformation_ProviderID',
        'mobilegridcell_16': 'serverinformation_mobilegridcell_16',
        'mobilelabel_26': 'serverinformation_mobilelabel_26',
        'mobilegridcell_17': 'serverinformation_mobilegridcell_17',
        'Address': 'serverinformation_Address',
        'mobilegridcell_18': 'serverinformation_mobilegridcell_18',
        'mobilelabel_27': 'serverinformation_mobilelabel_27',
        'mobilegridcell_19': 'serverinformation_mobilegridcell_19',
        'email': 'serverinformation_email',
        'mobilegridcell_20': 'serverinformation_mobilegridcell_20',
        'mobilelabel_28': 'serverinformation_mobilelabel_28',
        'mobilegridcell_21': 'serverinformation_mobilegridcell_21',
        'expiredate': 'serverinformation_expiredate',
        'mobilegridcell_22': 'serverinformation_mobilegridcell_22',
        'mobilelabel_29': 'serverinformation_mobilelabel_29',
        'mobilegridcell_23': 'serverinformation_mobilegridcell_23',
        'userno': 'serverinformation_userno'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=footer]").css("bottom", "-36px");
    }

    Appery.CurrentScreen = 'serverinformation';

    /*
     * Nonvisual components
     */
    var datasources = [];

    si = new Appery.DataSource(serverinfo, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("serverinformation");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'serverinfo[0]', 'company'],
            'ID': 'company',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'serverinfo[0]', 'expire_date'],
            'ID': 'expiredate',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'serverinfo[0]', 'provider'],
            'ID': 'provider',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'serverinfo[0]', 'software'],
            'ID': 'software',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'serverinfo[0]', 'usrno'],
            'ID': 'userno',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'serverinfo[0]', 'applicid'],
            'ID': 'ApplicationID',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'serverinfo[0]', 'providerid'],
            'ID': 'ProviderID',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'serverinfo[0]', 'address'],
            'ID': 'Address',
            'ATTR': '@'
        }, {
            'PATH': ['data', 'serverinfo[0]', 'email'],
            'ID': 'email',
            'ATTR': '@'
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'Authorization_string'
        }]
    });

    datasources.push(si);

    /*
     * Events and handlers
     */

    // Before Show
    serverinformation_beforeshow = function() {
        Appery.CurrentScreen = "serverinformation";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_8B73_onLoad = serverinformation_onLoad = function() {
        screen_8B73_elementsExtraJS();
        try {
            si.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        serverinformation_deviceEvents();
        serverinformation_windowEvents();
        screen_8B73_elementsEvents();
    }

    // screen window events
    screen_8B73_windowEvents = serverinformation_windowEvents = function() {
        $('#serverinformation').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    serverinformation_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_8B73_elementsExtraJS = serverinformation_elementsExtraJS = function() {
        // screen (serverinformation) extra code

    }

    // screen elements handler
    screen_8B73_elementsEvents = serverinformation_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

    }

    $("#serverinformation").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        serverinformation_beforeshow();
    });

    if (runBeforeShow) {
        serverinformation_beforeshow();
    } else {
        serverinformation_onLoad();
    }

}

$("#serverinformation").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    serverinformation_js();
});