/*
 * JS for servicelist generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '1c0ae847-f0fd-4b68-97b2-853cc35aa54f';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "EditService",
    "location": "EditService.html"
}, {
    "name": "ApiPage",
    "location": "ApiPage.html"
}, {
    "name": "test",
    "location": "test.html"
}, {
    "name": "StartPage",
    "location": "StartPage.html"
}, {
    "name": "StartScreen",
    "location": "StartScreen.html"
}, {
    "name": "table_details",
    "location": "table_details.html"
}, {
    "name": "servicelist",
    "location": "servicelist.html"
}, {
    "name": "Database",
    "location": "Database.html"
}, {
    "name": "StartApp",
    "location": "StartApp.html"
}, {
    "name": "serverinformation",
    "location": "serverinformation.html"
}];

$(document).bind('scroll', function() {
    adjustContentHeight();
});
$(window).bind(window.orientation ? 'orientationchange' : 'resize', function() {
    adjustContentHeight();
});

servicelist_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'Category_label': 'servicelist_Category_label',
        'spacer_30': 'servicelist_spacer_30',
        'servicesgrid': 'servicelist_servicesgrid',
        'mobilegridcell_6': 'servicelist_mobilegridcell_6',
        'servicename': 'servicelist_servicename',
        'service_id': 'servicelist_service_id',
        'mobilegridcell_7': 'servicelist_mobilegridcell_7',
        'status_onoff': 'servicelist_status_onoff',
        'mobilegridcell_24': 'servicelist_mobilegridcell_24',
        'mobilelabel_49': 'servicelist_mobilelabel_49',
        'method': 'servicelist_method',
        'mobilegridcell_25': 'servicelist_mobilegridcell_25',
        'mobilelabel_50': 'servicelist_mobilelabel_50',
        'language': 'servicelist_language',
        'mobilegridcell_31': 'servicelist_mobilegridcell_31',
        'mobilegrid_32': 'servicelist_mobilegrid_32',
        'mobilegridcell_33': 'servicelist_mobilegridcell_33',
        'edit_srv': 'servicelist_edit_srv',
        'mobilegridcell_34': 'servicelist_mobilegridcell_34'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=footer]").css("bottom", "-36px");
    }

    Appery.CurrentScreen = 'servicelist';

    /*
     * Nonvisual components
     */
    var datasources = [];

    list_of_services = new Appery.DataSource(listse, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("servicelist");
        },
        'onSuccess': function(data) {
            setText('servicelist_Category_label', localStorage.getItem('select_category'));
        },
        'onError': function(jqXHR, textStatus, errorThrown) {
            alert('error loading data!');
        },
        'responseMapping': [{
            'PATH': ['data', 'listse'],
            'ID': 'servicesgrid',
            'SET': [{
                'PATH': ['id_code'],
                'ID': 'service_id',
                'ATTR': '@'
            }, {
                'PATH': ['command_'],
                'ID': 'servicename',
                'ATTR': '@'
            }, {
                'PATH': ['enabled'],
                'ID': 'status_onoff',
                'ATTR': '@'
            }, {
                'PATH': ['language'],
                'ID': 'language',
                'ATTR': '@'
            }, {
                'PATH': ['method_r'],
                'ID': 'method',
                'ATTR': '@'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'Authorization_string'
        }, {
            'PATH': ['categoryname'],
            'ID': '___local_storage___',
            'ATTR': 'select_category'
        }]
    });

    datasources.push(list_of_services);

    /*
     * Events and handlers
     */

    // Before Show
    servicelist_beforeshow = function() {
        Appery.CurrentScreen = "servicelist";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_C416_onLoad = servicelist_onLoad = function() {
        screen_C416_elementsExtraJS();
        try {
            list_of_services.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        servicelist_deviceEvents();
        servicelist_windowEvents();
        screen_C416_elementsEvents();
    }

    // screen window events
    screen_C416_windowEvents = servicelist_windowEvents = function() {
        $('#servicelist').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    servicelist_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_C416_elementsExtraJS = servicelist_elementsExtraJS = function() {
        // screen (servicelist) extra code

    }

    // screen elements handler
    screen_C416_elementsEvents = servicelist_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

        $('#servicelist_mobilecontainer4 [name="edit_srv"]').die().live({
            click: function() {
                if (!$(this).attr('disabled')) {
                    setVar_('selected_service', 'servicelist_service_id', 'text', '', this);
                    Appery.navigateTo('EditService', {
                        transition: 'fade',
                        reverse: false
                    });

                }
            },
        });

    }

    $("#servicelist").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        servicelist_beforeshow();
    });

    if (runBeforeShow) {
        servicelist_beforeshow();
    } else {
        servicelist_onLoad();
    }

}

$("#servicelist").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    servicelist_js();
});