/*
 * JS for table_details generated by Appery.io
 *
 */

Appery.getProjectGUID = function() {
    return '1c0ae847-f0fd-4b68-97b2-853cc35aa54f';
}

function navigateTo(outcome, useAjax) {
    Appery.navigateTo(outcome, useAjax);
}

function adjustContentHeight() {
    Appery.adjustContentHeight();
}

function adjustContentHeightWithPadding() {
    Appery.adjustContentHeightWithPadding();
}

function setDetailContent(pageUrl) {
    Appery.setDetailContent(pageUrl);
}

Appery.AppPages = [{
    "name": "EditService",
    "location": "EditService.html"
}, {
    "name": "ApiPage",
    "location": "ApiPage.html"
}, {
    "name": "test",
    "location": "test.html"
}, {
    "name": "StartPage",
    "location": "StartPage.html"
}, {
    "name": "StartScreen",
    "location": "StartScreen.html"
}, {
    "name": "table_details",
    "location": "table_details.html"
}, {
    "name": "servicelist",
    "location": "servicelist.html"
}, {
    "name": "Database",
    "location": "Database.html"
}, {
    "name": "StartApp",
    "location": "StartApp.html"
}, {
    "name": "serverinformation",
    "location": "serverinformation.html"
}];

$(document).bind('scroll', function() {
    adjustContentHeight();
});
$(window).bind(window.orientation ? 'orientationchange' : 'resize', function() {
    adjustContentHeight();
});

table_details_js = function(runBeforeShow) { /* Object & array with components "name-to-id" mapping */
    var n2id_buf = {
        'spacer_9': 'table_details_spacer_9',
        'mobilegrid_10': 'table_details_mobilegrid_10',
        'mobilegridcell_11': 'table_details_mobilegridcell_11',
        'mobilelabel_7': 'table_details_mobilelabel_7',
        'mobilegridcell_12': 'table_details_mobilegridcell_12',
        'mobilelabel_6': 'table_details_mobilelabel_6',
        'spacer_15': 'table_details_spacer_15',
        'table_detail': 'table_details_table_detail',
        'mobilegridcell_17': 'table_details_mobilegridcell_17',
        'mobilelabel_22': 'table_details_mobilelabel_22',
        'mobilegridcell_18': 'table_details_mobilegridcell_18',
        'mobilelabel_23': 'table_details_mobilelabel_23',
        'mobilegridcell_21': 'table_details_mobilegridcell_21',
        'mobilelabel_24': 'table_details_mobilelabel_24',
        'table_details_grid': 'table_details_table_details_grid',
        'mobilegridcell_26': 'table_details_mobilegridcell_26',
        'field_name': 'table_details_field_name',
        'mobilegridcell_27': 'table_details_mobilegridcell_27',
        'field_type': 'table_details_field_type',
        'mobilegridcell_30': 'table_details_mobilegridcell_30',
        'field_lenght': 'table_details_field_lenght',
        'mobilegridcell_35': 'table_details_mobilegridcell_35',
        'field_dec': 'table_details_field_dec',
        'spacer_36': 'table_details_spacer_36',
        'mobilelabel_37': 'table_details_mobilelabel_37'
    };

    if ("n2id" in window && window.n2id !== undefined) {
        $.extend(n2id, n2id_buf);
    } else {
        window.n2id = n2id_buf;
    }

    if (navigator.userAgent.indexOf("IEMobile") != -1) {
        //Fixing issue https://github.com/jquery/jquery-mobile/issues/5424 on Windows Phone
        $("div[data-role=footer]").css("bottom", "-36px");
    }

    Appery.CurrentScreen = 'table_details';

    /*
     * Nonvisual components
     */
    var datasources = [];

    tdetail = new Appery.DataSource(tabledetail, {
        'onComplete': function(jqXHR, textStatus) {

            $t.refreshScreenFormElements("table_details");
        },
        'onSuccess': function(data) {},
        'onError': function(jqXHR, textStatus, errorThrown) {},
        'responseMapping': [{
            'PATH': ['data', 'tabledetail'],
            'ID': 'table_details_grid',
            'SET': [{
                'PATH': ['fieldname'],
                'ID': 'field_name',
                'ATTR': '@'
            }, {
                'PATH': ['fieldtype'],
                'ID': 'field_type',
                'ATTR': '@'
            }, {
                'PATH': ['fieldlenght'],
                'ID': 'field_lenght',
                'ATTR': '@'
            }, {
                'PATH': ['fielddim'],
                'ID': 'field_dec',
                'ATTR': '@'
            }]
        }],
        'requestMapping': [{
            'PATH': ['Authorization'],
            'HEADER': true,
            'ID': '___local_storage___',
            'ATTR': 'Authorization_string'
        }, {
            'PATH': ['tablename'],
            'ID': '___local_storage___',
            'ATTR': 'selected_table'
        }]
    });

    datasources.push(tdetail);

    /*
     * Events and handlers
     */

    // Before Show
    table_details_beforeshow = function() {
        Appery.CurrentScreen = "table_details";
        for (var idx = 0; idx < datasources.length; idx++) {
            datasources[idx].__setupDisplay();
        }
    }

    // On Load
    screen_C1D9_onLoad = table_details_onLoad = function() {
        screen_C1D9_elementsExtraJS();
        setText('table_details_mobilelabel_6', localStorage.getItem('selected_table'));
        try {
            tdetail.execute({})
        } catch (ex) {
            console.log(ex.name + '  ' + ex.message);
            hideSpinner();
        };

        // TODO fire device events only if necessary (with JS logic)
        table_details_deviceEvents();
        table_details_windowEvents();
        screen_C1D9_elementsEvents();
    }

    // screen window events
    screen_C1D9_windowEvents = table_details_windowEvents = function() {
        $('#table_details').bind('pageshow orientationchange', function() {
            adjustContentHeightWithPadding();
        });

    }

    // device events
    table_details_deviceEvents = function() {

        document.addEventListener("deviceready", function() {

        });
    }

    // screen elements extra js
    screen_C1D9_elementsExtraJS = table_details_elementsExtraJS = function() {
        // screen (table_details) extra code

    }

    // screen elements handler
    screen_C1D9_elementsEvents = table_details_elementsEvents = function() {

        $("a :input,a a,a fieldset label").live({
            click: function(event) {
                event.stopPropagation();
            }
        });

    }

    $("#table_details").die("pagebeforeshow").live("pagebeforeshow", function(event, ui) {
        table_details_beforeshow();
    });

    if (runBeforeShow) {
        table_details_beforeshow();
    } else {
        table_details_onLoad();
    }

}

$("#table_details").die("pageinit").live("pageinit", function(event, ui) {
    Appery.processSelectMenu($(this));
    table_details_js();
});